<?php $__env->startSection('content'); ?>

<style type="text/css">
    .table td, .table th {
        font-size: 13px;
        line-height: 2.42857 !important;
    }
</style>

<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">

<div class="page-content-wrapper">
    <div class="page-content">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a href="<?php echo e(route('admin.home')); ?>">Home</a> <i class="fa fa-circle"></i> </li>
                <li> <span>Applied Users</span> </li>
            </ul>
        </div>
        
        <?php
            if(Request::segment(3)){
                $job = App\Job::findOrFail(Request::segment(3));
            }
        ?>
        
        <div class="row">
            <div class="col-md-12">
                <div class="myads">
                    <h3><?php echo e(__('Candidates listed against')); ?> (<?php echo e($job->title); ?>)</h3>
                    <button id="downloadCsv" class="btn btn-success">Download CSV</button>
                    <br><br>
                    <table id="appliedUsersTable" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Candidate Name</th>
                                <th>Location</th>
                                <th>Expected Salary</th>
                                <th>Experience</th>
                                <th>Career Level</th>
                                <th>Phone</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($job_applications) && count($job_applications)): ?>
                                <?php $__currentLoopData = $job_applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $user = $job_application->getUser();
                                        $job = $job_application->getJob();
                                        $company = $job->getCompany();             
                                        $profileCv = $job_application->getProfileCv();
                                    ?>
                                    <?php if($user && $job && $company && $profileCv): ?>
                                        <tr>
                                            <td><a href="<?php echo e(route('admin.view.public.profile', $user->id)); ?>"><?php echo e($user->getName()); ?></a></td>
                                            <td><?php echo e($user->getLocation()); ?></td>
                                            <td><?php echo e($job_application->expected_salary); ?> <?php echo e($job_application->salary_currency); ?></td>
                                            <td><?php echo e($user->getJobExperience('job_experience')); ?></td>
                                            <td><?php echo e($user->getCareerLevel('career_level')); ?></td>
                                            <td><?php echo e($user->phone); ?></td>
                                            <td><a class="btn btn-primary btn-sm" href="<?php echo e(route('admin.view.public.profile', [$user->id, 'company_id='.$company_id, 'job_id='.$job_id])); ?>">View Profile</a></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="text-center">No Candidates applied yet</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function() {
        $('#appliedUsersTable').DataTable();

        $('#downloadCsv').click(function () {
            let csvContent = "data:text/csv;charset=utf-8," + "Name,Location,Expected Salary,Experience,Career Level,Phone\n";
            
            <?php if(isset($job_applications) && count($job_applications)): ?>
                <?php $__currentLoopData = $job_applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $user = $job_application->getUser();
                        $job = $job_application->getJob();
                    ?>
                    <?php if($user && $job): ?>
                        csvContent += `"<?php echo e($user->getName()); ?>","<?php echo e($user->getLocation()); ?>","<?php echo e($job_application->expected_salary); ?> <?php echo e($job_application->salary_currency); ?>","<?php echo e($user->getJobExperience('job_experience')); ?>","<?php echo e($user->getCareerLevel('career_level')); ?>","<?php echo e($user->phone); ?>"\n`;
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            let encodedUri = encodeURI(csvContent);
            let link = document.createElement("a");
            link.setAttribute("href", encodedUri);
            link.setAttribute("download", "applied_users_<?php echo e($job->title); ?>.csv");
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp8\htdocs\jobsportal\resources\views/admin/job/job_applications.blade.php ENDPATH**/ ?>